unit Resize;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, Pyrolab, ExtCtrls, Pyroedit;

type
  TResizeDlg = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    SizeLabel: TPyroLabel;
    XSize: TPyroEdit;
    Ysize: TPyroEdit;
    Zsize: TPyroEdit;
    Xoffset: TPyroEdit;
    YOffset: TPyroEdit;
    ZOffset: TPyroEdit;
    Label8: TLabel;
    procedure AttemptResize(Sender: TObject);
    procedure init(Sender: TObject);
    procedure DisplayObjectSize(Sender:TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ResizeDlg: TResizeDlg;

implementation

uses
    Maptest;

{$R *.DFM}

procedure TResizeDlg.AttemptResize(Sender: TObject);
var
newmap:TMemoryStream;
begin
     xdim:=xsize.number;
     ydim:=ysize.number;
     zdim:=zsize.number;

     xoffs:=xoffset.number;
     yoffs:=yoffset.number;
     zoffs:=zoffset.number;
     with mapeditor.mapdisplay do begin
          if (xdim<map.xdim) or (ydim<map.ydim) or (zdim<map.zdim) then
             if Application.MessageBox('Map will be clipped. Continue?','Warning',mb_YesNo)=IDNO then Exit;
             if (xoffs<0) or (yoffs<0) or (zoffs<0) then begin
                Application.MessageBox('Offset values should be positive. They represent'+
                ' how much the copied map will be offset into the new one.'
                ,'Error',0);
                Exit;
             end;
             if (xoffs>xdim) or (yoffs>ydim) or (zoffs>zdim) then begin
                Application.MessageBox('Offset values should be less than the map size.'+
                'Otherwise, the copied map would be 100% clipped.',
                'Error',0);
                Exit;
             end;
             modalresult:=mrOk;
     end;

end;

procedure TResizeDlg.init(Sender: TObject);
begin
     with mapeditor.mapdisplay do begin
          xsize.number:=map.xdim;
          ysize.number:=map.ydim;
          zsize.number:=map.zdim;
          DisplayObjectSize(Sender);
     end;
end;

procedure TResizeDlg.DisplayObjectSize(Sender:Tobject);
begin
     SizeLabel.Number:=Xsize.number*YSize.number*ZSize.number;
end;

end.
